/*
 * @(#)CompareRERModelsAction.java  1.0  15. Februar 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.rer;

import java.awt.event.*;
import javax.swing.*;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * CompareRERModelsAction.
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 15. Februar 2006 Created.
 */
public class CompareRERModelsAction extends AbstractViewAction {
    //private CERProject project;
    public final static String ID = "verify";
    
    /** Creates a new instance. */
    public CompareRERModelsAction(Application app, View v) {
       super(app,v);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.rer.Labels");
        labels.configureAction(this, ID);
       // this.project = p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RERView project = (RERView) getActiveView();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.rer.Labels");
        java.util.List<String> differences = project.getProblemModel().describeDifferencesTo(project.getSolutionModel());
        String message;
        if (differences.size() == 0) {
            message = labels.getString("noDiffsFound");
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            buf.append("<ul>");
            for (String str : differences) {
                buf.append("<li>");
                buf.append(str);
                buf.append("</li>");
            }
            buf.append("</ul>");
            message = buf.toString();
        }
        JOptionPane.showMessageDialog(project.getComponent(), message
                );
    }
    
}